;program v2.11c,  PROGRAM  pro ladeni 2.11ky
;----------funkcni encoder pro nastaveni period a vykonu------------

;nabeh na plny vykon 5 period			


	LIST   P=16F628A, R = DEC		 
	#include <p16F628A.inc>		 

	errorlevel  -302              		      ; suppress message 302 from list file

	__CONFIG   _CP_OFF & _DATA_CP_OFF & _LVP_OFF & _BODEN_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _XT_OSC

				
;====================================================================================
;---------------------------------------------------------------------
;||||||||||| KONSTANTY PROGRAMU ||||||||||||||
;---------------------------------------------------------------------
#define		DET_Z		PORTB,0		;IN pulsu z obvodu detektoru nuly
#define		DRIVE		PORTB,1		;OUT buzeni tyristoru [pozitivni]
#define		DRIVE_N		PORTB,2		;OUT uroven H blokuje buzeni tyristoru
#define		PERPW_B		PORTB,3		;PER/PW button
#define		ENC_B		PORTB,4		;IN encoder B
#define		ENC_A		PORTB,5		;IN encoder A
#define		PRESET_B	PORTB,6		;PRESET button
#define		PULSE_B		PORTB,7		;PULSE button
#define		TEMP_TY		PORTA,0		;IN teplotniho cidla tyristoru
#define		TEMP_TR		PORTA,1		;IN teplotniho cidla trafa
#define		SCL		PORTA,2		;OUT clock display driveru
#define		SDA		PORTA,3		;OUT data display driveru
#define		LVR_SW		PORTA,4		;IN	spinac v pace
#define		DP		DISPLAY_FL,0    ;BIT vstupni - zobrazeni DECIMAL POINT
#define		PERPW_F		DISPLAY_FL,3	;BIT vstupni , 1-zobr. PW , 0-zobr. PER
#define		F_INC		DISPLAY_FL,6	;BIT priznakovy pracovni-INC or DEC rot. encoder
#define		F_RENCOUT	DISPLAY_FL,7	;BIT priznakovy pracovni,1-ukonci rutinu rot. encoder
#define		ZPF		SPOT_FL,0	;ZeroPulsFlag [ 0-obsah TMR1L do ZP_TIME]
#define		LVROFF_F	SPOT_FL,7	;1-byla rozepnuta paka

ZNAK_BL	EQU		10		;58
ZNAK_A	EQU		11		;59
ZNAK_E	EQU		12		;60
ZNAK_F	EQU		13		;61
ZNAK_h 	EQU		14		;62	
ZNAK_O	EQU		0		;48
ZNAK_P	EQU		15		;63
ZNAK_r  EQU		16		;64
ZNAK_S	EQU		5		;53
ZNAK_t	EQU		17		;65	

OFFRAM	EQU		H'20'				;zacatek volne pameti "RAM"
TEMPRAM	EQU		H'70'				;posledni blok pameti (16 bytu)-
							;je zrcadlen do vsech pametovych bank	
;----------------------------------------------------------------------
;||||||||||| PROGRAMOVE PROMENNE |||||||||||||
;----------------------------------------------------------------------
	CBLOCK	 OFFRAM+1
	ZP_TIME:1 ; doba trvani pulsu nuly [ instr. cykl /4 ]
	PER:1	  ; regitr period
	PER_C:1	  ; cykl period
	PW:1	  ; registr vykonu
	PW_N:1	  ; negovany vykon
	PW_C:1	  ; cykl vykonu
	CYKLSEG:1	
	DECYKL:1	
	LONGW:1	
	DIG1:1    ; obsah 1 digitu
	DIG2:1
	DIG3:1
	DIG4:1
	T_DIG1:1  ; graficky obsah 1 digitu
	T_DIG2:1
	T_DIG3:1
	T_DIG4:1
	NUM:1
	JEDN:1
	DES:1
	STA:1
	CYKL1:1
	TMP0:1
	TMP1:1
	DISPLAY_FL:1
	SPOT_FL:1
	KEY_FL:1
	ENDC
	CBLOCK	 TEMPRAM	; zalozni registry, ktere
	W_TEMP:1		; jsou nezavisle na zvolene
	ST_TEMP:1		; pametove bance !!!
	FSR_TEMP:1
	PCL_TEMP:1
	ENDC
;************************ Nastaven dat v EEPROM **************************

	ORG	0x2100										; tabulka v pameti EEPROM (128 bytu)
	de	0x23, 0x07, 0x19, 0x74, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF

	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	de	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;*******************************************************************************
;====================================================================================
	    	ORG	0
	    	GOTO    INIT 
		ORG	4
;---------------------------------------------------------obsluha preruseni
		MOVWF	W_TEMP		; zaloha registru W,STATUS a FSR
		MOVF	STATUS,W
		MOVWF	ST_TEMP
		MOVF	FSR,W
		MOVWF	FSR_TEMP
		BANKSEL	0
		MOVFW	PCLATH
		MOVWF	PCL_TEMP
;-------------------------------
		MOVFW	TMR1L
		MOVWF	ZP_TIME
		BSF	ZPF
		BCF	INTCON,INTF

;------------------------------- (obnoven hodnot registru W a STATUS)
INT_END 	MOVFW	PCL_TEMP
		MOVWF	PCLATH		; obnova PCLATH
		MOVFW	FSR_TEMP	; obnova registru ze zalohy
		MOVWF	FSR
		MOVFW	ST_TEMP
		MOVWF	STATUS
		SWAPF	W_TEMP,F
		SWAPF	W_TEMP,W
		
		RETFIE	
;===========================================================
;|||||||||||||||||||	ROUTINES   |||||||||||||||||||||||||
;===========================================================
		#include	display.inc
	
;-----------------------------------------------------------
CLOSE_G		BSF	DRIVE_N		; zavreni tyristoru
		BCF	DRIVE
		BTFSS	DRIVE_N
		GOTO	$-3
		BTFSC	DRIVE
		GOTO	$-4
		RETURN

OPEN_G		BCF	DRIVE_N		; otevreni tyristoru
		BSF	DRIVE
		BTFSC	DRIVE_N
		GOTO	$-3
		BTFSS	DRIVE
		GOTO	$-4
		RETURN
;-----------------------------------------------------------
DELAY_1M	MOVLW 	0x1B  	;27 DEC  , Delay 1000 uS
     		MOVWF 	TMP1
       		MOVLW 	0x0B  	;11 DEC
       		MOVWF 	TMP0
       		DECFSZ	TMP0,F
       		GOTO 	$-1
        	DECFSZ 	TMP1,F
       		GOTO 	$-5
		RETURN
		
DELAY_X1M	BTFSC	STATUS,Z	; jestlize byl obsah PW_C nulovy , ukonci rutinu
		GOTO	$+5
		MOVWF	CYKL1
		CALL	DELAY_1M
		DECFSZ	CYKL1,F
		GOTO	$-2
		RETURN	
;----------------------------------------------------------------------
KEYTEST_OUT	BTFSS	LVR_SW
		GOTO	$+3
		BTFSC	PERPW_B
		RETURN	
		BSF	F_RENCOUT
		GOTO	$-2
;----------------------------------------------------------------------
D_REFRESH	BTFSC	PERPW_F
		GOTO	REFR_PW
		MOVFW	PER		;refresh PER
		MOVWF	NUM
		CALL	CON_N3D
		MOVFW	JEDN
		MOVWF	DIG1
		MOVFW	DES
		MOVWF	DIG2
		MOVFW	STA
		MOVWF	DIG3
		MOVLW	ZNAK_BL
		MOVWF	DIG4
		CALL	PRINT_D
		GOTO	D_REFEND
REFR_PW		MOVF	PW,F
		BTFSC 	STATUS,Z
		INCF	PW,F
		MOVFW	PW
		SUBLW	10
		BTFSS	STATUS,C
		DECF	PW,F
		MOVFW	PW		;refresh PW
		MOVWF	NUM
		CALL	CON_N3D
		MOVFW	JEDN
		MOVWF	DIG1
		MOVFW	DES
		MOVWF	DIG2
		MOVLW	ZNAK_BL
		MOVWF	DIG3
		MOVLW	ZNAK_P
		MOVWF	DIG4
		CALL	PRINT_D
D_REFEND	RETURN
		
;----------------------------------------------------------------------
;CON_N3D prevede cislo uloen v registru NUM na jednotky,
;desitky a sta. ( 0 - 255 ) POZOR! Deformuje obsah registru NUM.
CON_N3D		CLRF		JEDN
		CLRF		DES
		CLRF		STA
		MOVLW		100
		SUBWF		NUM,W		;registr W=NUM-100
		BTFSS		STATUS,C	;doslo k podteceni?
		GOTO		$+4		;ano,udelej skok
		MOVWF		NUM		;obsah W do NUM
		INCF		STA,F		;registr STA + 1
		GOTO		$-6		;odecitej znova 
		MOVLW		10
		SUBWF		NUM,W		;registr W=NUM-10
		BTFSS		STATUS,C	;doslo k podteceni?
		GOTO		$+4		;ano,udelej skok
		MOVWF		NUM		;obsah W do NUM
		INCF		DES,F		;registr DES + 1
		GOTO		$-6		;odecitej znova 
		MOVFW		NUM
		ADDWF		JEDN,1		;zbytek pricist do registru JEDN
		RETURN
;================================================================================================================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;================================================================================================================
INIT  		CLRF	INTCON
		BANKSEL	PORTA
		CLRF	PORTA
		CLRF	PORTB
		BANKSEL	TRISA	
		MOVLW	19		;nastav porta na 00010011
		MOVWF 	TRISA
		MOVLW	249		;nastav portb na 11111001
		MOVWF	TRISB
		BANKSEL	0
		MOVLW	7
		MOVWF	CMCON	
		CALL	CLOSE_G
;-----------------------------------------
DFG		BCF	PERPW_F		;inicializace registru PER+PW
		MOVLW	20
		MOVWF	PER
		MOVLW	5
		MOVWF	PW
		BCF	DP
		CALL	D_REFRESH
;-----------------------------------------			
START		BTFSC	LVR_SW
		GOTO	PPT
		MOVLW	255
		MOVWF	CYKL1
		BTFSC	LVR_SW		
		GOTO	PPT
		DECFSZ	CYKL1,F
		GOTO	$-3
		GOTO  	S_SPOT
		
PPT		BTFSC	PERPW_B
		GOTO	DETERM	
		MOVLW	255
		MOVWF	CYKL1
		BTFSC	PERPW_B		
		GOTO	DETERM
		DECFSZ	CYKL1,F
		GOTO	$-3
MID		BTFSS	PERPW_B
		GOTO	MID	
		MOVLW	255
		MOVWF	CYKL1
		BTFSS	PERPW_B		
		GOTO	MID
		DECFSZ	CYKL1,F
		GOTO	$-3

		BTFSS	PERPW_F	;begin bit toggle
		GOTO	$+3	;	
		BCF	PERPW_F	;
		GOTO	$+2	;
		BSF	PERPW_F	;end BTG
		CALL	D_REFRESH
		
;-------------------------------------------------------------------
DETERM		MOVLW 	H'20'
		MOVWF	FSR
		BTFSS	PERPW_F	    	;begin determining INC[DEC] PER-PW
		GOTO	ENCODER_PER
		GOTO	ENCODER_PW	;end determining
			
;--------------------------------------		
ENCODER_PER	BCF	F_RENCOUT
		BTFSS	ENC_A		;vetveni LikeINCremental
		GOTO	LINC
		BTFSS	ENC_B		;a LikeDECremental
		GOTO	LDEC
		GOTO	OUT
;---------------------------------------------------------------
LINC		BTFSS	ENC_B
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT
		GOTO	$-5
		BCF	F_INC		;|
		BTFSS	ENC_A		;|
		BSF	F_INC		;|
		BTFSC	ENC_A
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT
		GOTO	$-5
		BTFSC	ENC_B
		GOTO	OUT
		BTFSS	F_INC
		GOTO	OUT
		INCF	PER,F
		CALL	D_REFRESH
		GOTO	OUT

LDEC		BTFSS	ENC_A
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT
		GOTO	$-5
		BSF	F_INC		;|
		BTFSS	ENC_B		;|
		BCF	F_INC		;|
		BTFSC	ENC_B
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT
		GOTO	$-5
		BTFSC	ENC_A
		GOTO	OUT
		BTFSC	F_INC
		GOTO	OUT
		DECF	PER,F
		CALL	D_REFRESH
		GOTO	OUT
		
OUT		BCF	F_RENCOUT
		GOTO   	START		

ENCODER_PW	BCF	F_RENCOUT
		BTFSS	ENC_A		;vetveni LikeINCremental
		GOTO	LINC1
		BTFSS	ENC_B		;a LikeDECremental
		GOTO	LDEC1
		GOTO	OUT1
;---------------------------------------------------------------
LINC1		BTFSS	ENC_B
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT1
		GOTO	$-5
		BCF	F_INC		;|
		BTFSS	ENC_A		;|
		BSF	F_INC		;|
		BTFSC	ENC_A
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT1
		GOTO	$-5
		BTFSC	ENC_B
		GOTO	OUT1
		BTFSS	F_INC
		GOTO	OUT1
		INCF	PW,F
		CALL	D_REFRESH
		GOTO	OUT1

LDEC1		BTFSS	ENC_A
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT1
		GOTO	$-5
		BSF	F_INC		;|
		BTFSS	ENC_B		;|
		BCF	F_INC		;|
		BTFSC	ENC_B
		GOTO	$+5
		CALL	KEYTEST_OUT
		BTFSC	F_RENCOUT
		GOTO	OUT1
		GOTO	$-5
		BTFSC	ENC_A
		GOTO	OUT1
		BTFSC	F_INC
		GOTO	OUT1
		DECF	PW,F
		CALL	D_REFRESH
		GOTO	OUT1
		
OUT1		BCF	F_RENCOUT
		GOTO   	START		


;=======================================================================================

S_SPOT		CALL	CLOSE_G
		;ZHASNI DISPLAY
		;ULOZ HODNOTY REG. DO EEPROM
		MOVFW	PER		; prenos z registru PER do PER_C
		MOVWF	PER_C
		MOVFW	PW		; vytvoreni negovane hodnoty vykonu
		SUBLW	10		;	
		MOVWF	PW_N		;
		MOVLW	9
		MOVWF	PW_C
		banksel	OPTION_REG	;| 
		MOVLW	B'11001001'	;| povoli PULL UP, preruseni sestupnou hranou RB0
		MOVWF	OPTION_REG	;| priradi prescaler k WDT a nastavi ho 1:2
		banksel	0		;|
		CLRWDT
		MOVLW	B'00110001'		
		MOVWF	T1CON		; zapne TMR1 a nastavi preddelicku na 1:8	
		CLRF	INTCON		; zakaze jakekoli preruseni
		BTFSC	DET_Z		;| zmeri ZERO PULS :4
		GOTO	$-1		;|	
		CLRF	TMR1H		;|
		CLRF	TMR1L		;|
		BTFSS	DET_Z		;|	
		GOTO	$-1		;|	
		MOVFW	TMR1L		;| a ulozi do ZP_TIME
		MOVWF	ZP_TIME		;|
		BCF	LVROFF_F
	
		

;-------------Prvni pulka periody---------------------	
HEAT		BTFSC	LVR_SW
		BSF	LVROFF_F
		BTFSC	DET_Z
		GOTO	$-1
		CLRF	TMR1H		;|
		CLRF	TMR1L		;|
		MOVFW	ZP_TIME
		banksel	PR2
		MOVWF	PR2
		banksel	0
		MOVLW	B'00011100'	; zapne TMR2 - 1:4 postscaler
		MOVWF	T2CON
		CLRF	TMR2
		BCF	PIR1,TMR2IF
		BTFSC	PIR1,TMR2IF
		GOTO	$-2
		BTFSS	PIR1,TMR2IF
		GOTO	$-1
		CALL	CLOSE_G

		BCF	ZPF 		;
		BTFSC	ZPF 		;
		GOTO	$-2  		;
		MOVLW	B'10010000'	;| 
		MOVWF	INTCON		;| povoli globalni preruseni a prer. od RB0
		MOVFW	PW_C		; load cekaci periody vykonu do W
		CALL	DELAY_X1M	; cekani na otevreni tyristoru [doba zavreni]
		CALL	OPEN_G		; otevri TYR
		BTFSC	ZPF
		GOTO	$+4
		CALL	DELAY_1M
		BTFSS	ZPF
		GOTO	END_SPOT
		CLRF	INTCON
;--------------------------------
		MOVF	PW_C,F
		BTFSS	STATUS,Z
		DECF	PW_C,F		
		MOVFW	PW_N
		SUBWF	PW_C,W
		BTFSS	STATUS,C
		INCF	PW_C,F
;--------------------------------
		BTFSC	DET_Z
		GOTO	$-1
		
		CLRF	TMR1H		;|
		CLRF	TMR1L		;|
;--------Druha pulka periody-------------------------			
		
		MOVFW	ZP_TIME
		banksel	PR2
		MOVWF	PR2
		banksel	0
		MOVLW	B'00011100'	; zapne TMR2 - 1:4 postscaler
		MOVWF	T2CON
		CLRF	TMR2
		BCF	PIR1,TMR2IF
		BTFSC	PIR1,TMR2IF
		GOTO	$-2
		BTFSS	PIR1,TMR2IF
		GOTO	$-1
		CALL	CLOSE_G

		BCF	ZPF 		;
		BTFSC	ZPF 		;
		GOTO	$-2  		;
		MOVLW	B'10010000'	;| 
		MOVWF	INTCON		;| povoli globalni preruseni a prer. od RB0
		MOVFW	PW_C		; load cekaci periody vykonu do W
		CALL	DELAY_X1M	; cekani na otevreni tyristoru [doba zavreni]
		CALL	OPEN_G		; otevri TYR
		BTFSC	ZPF
		GOTO	$+4
		CALL	DELAY_1M
		BTFSS	ZPF
		GOTO	END_SPOT
		CLRF	INTCON
;---------------------------------------------------------
		BTFSS	LVR_SW		; test vypnuti paky
		GOTO	$+3
		BTFSC	LVROFF_F
		GOTO	END_SPOT
		BCF	LVROFF_F	; konec testu
		MOVF	PW_C,F
		BTFSS	STATUS,Z
		DECF	PW_C,F		
		MOVFW	PW_N
		SUBWF	PW_C,W
		BTFSS	STATUS,C
		INCF	PW_C,F
		DECF	PER_C,F
		MOVFW	PER_C
		SUBLW	1		; test konce bodovani [ pri 1 nebo 0 skonci ]
		BTFSS	STATUS,C	;
		GOTO	HEAT

END_SPOT  	CALL	CLOSE_G
		CLRF	INTCON
		BTFSS	LVR_SW
		GOTO	$-1
		GOTO	START

		
		END
